<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    function creaMenuAdmin($geecomDb,$prefissoLink,$ruolo) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        
        echo"<ul class=\"navbar-nav ml-lg-3 mr-auto\">
                <li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."home.php\">Home</a></li>\n";
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."impostazioni.php\">Impostazioni</a></li>\n
                    <li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."statistiche.php\">Statistiche</a></li>\n";
                }
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                      <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Utenti <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneUtenti.php?ruolo=super admin\">Amministratori</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneUtenti.php?ruolo=utente\">Utenti</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneUtenti.php?ruolo=nominativo\">Nominativi</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneGruppi.php\">Gruppi</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneEtichette.php\">Etichette</a>    
                        </div>
                    </li>";
                }
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestioneMenu.php\"> Menu</a></li>\n";
                }

                echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."gestionePagine.php\">Pagine</a></li>\n";
                echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                        <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Comunicazioni <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneComunicazioni.php?tipo=comunicazione\">Comunicazioni</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneComunicazioni.php?tipo=segnalazione\">Segnalazioni</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneComunicazioni.php?tipo=ticket\">Ticket</a>
                        </div>
                    </li>";
                
                if($impostazioni["attivaContabilita"]=="si") {
                    echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                            <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Contabilità <b class=\"caret\"></b></a>
                            <div class=\"dropdown-menu\">
                                <a class=\"dropdown-item\" href=\"".$prefissoLink."riepilogoContabilita.php\">Riepilogo</a>
                                <a class=\"dropdown-item\" href=\"".$prefissoLink."documentiContabili.php?tipo=prima nota\">Prima nota</a>
                                <a class=\"dropdown-item\" href=\"".$prefissoLink."documentiContabili.php?tipo=ricevuta\">Ricevute </a>
                                <a class=\"dropdown-item\" href=\"".$prefissoLink."documentiContabili.php?tipo=fattura\">Fatture </a>
                                <a class=\"dropdown-item\" href=\"".$prefissoLink."documentiContabili.php?tipo=preventivo\">Preventivi</a>
                            </div>
                    </li>";
                }
                
                echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                        <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Risorse <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."categorieRisorse.php\">Categorie</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."gestioneRisorse.php\">File</a>
                        </div>
                    </li>";
                
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    $queryComponente = "SELECT * FROM geecAd_componenti WHERE nome LIKE 'AssoSoft'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/assoSoft\">AssoSoft</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecAd_componenti WHERE nome LIKE 'Cogito'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/cogito\">Cogito</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecAd_componenti WHERE nome LIKE 'gSocial'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/gSocial\">gSocial</a></li>\n";
                    }
                    
                    $queryComponente = "SELECT * FROM geecAd_componenti WHERE nome LIKE 'Rum'";
                    $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);
                    if($risEcommerce->num_rows>0) {
                        echo"<li class=\"nav-item\"><a class=\"nav-link\" href=\"$prefissoLink"."componenti/rum\">Rum</a></li>\n";
                    }
                }
                
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item\"><a href=\"#\" data-toggle=\"modal\" data-target=\"#menu-componenti\" class=\"nav-link\" data-toggle=\"dropdown\">Componenti</a></li>";
                }
                
                if($ruolo=="amministratore" || $ruolo=="super admin") {
                    echo"<li class=\"nav-item dropdown sliding-u-l-r-l\">
                      <a href=\"#\" class=\"nav-link dropdown-toggle\" data-toggle=\"dropdown\">Strumenti <b class=\"caret\"></b></a>
                        <div class=\"dropdown-menu\">
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/backup\">Backup</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/importaEsporta\">Importa / esporta</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/informazioniSistema\">Informazioni di sistema</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/storicoOperazioni\">Storico operazioni</a>
                            <a class=\"dropdown-item\" href=\"$prefissoLink"."strumenti/testMail\">Test email</a>
                        </div>
                    </li>";
                }
        echo"</ul>";
    }

    //stampa il menu visibile agli utenti. Prende in input il database su cui fare la ricerca
    function creaMenu($db,$personalizzazioniMenu,$gruppiUtente,$lingua) {
    	$stringaGruppiUtenti = " AND (gruppoSpecifico=0";
    	foreach($gruppiUtente as $gruppo) {
    		$stringaGruppiUtenti .= " OR gruppoSpecifico=$gruppo ";
    	}
	$stringaGruppiUtenti .= ") ";
        
        $impostazioniLingua = $db->leggiSingolaRiga("geecAd_impostazioniLingue",1);
        $tipoMenu = "menu".ucfirst($lingua);
        $idMenu = $impostazioniLingua[$tipoMenu];

        $queryMenu = "SELECT * FROM geecAd_vociMenu WHERE idMenu=$idMenu AND tipo NOT LIKE 'voce sottoMenu' $stringaGruppiUtenti ORDER BY posizione ASC";
        if(!$risVociMenu = $db->eseguiQueryLettura($queryMenu)) {
            echo"errore nella creazione del menu ".$db->error;
            exit();
        }
        
        echo"<ul class=\"{$personalizzazioniMenu["classeMenu"]}\" >";
        while($voceMenu = $risVociMenu->fetch_assoc()) {
            if($voceMenu["tipo"]=="menu a tendina") { //se si tratta di un menu a tendina va a cercare tutte le voci che deve contenere
                echo"<li class=\"{$personalizzazioniMenu["elementoMenu"]}\">
                <a href=\"#dropwdown{$voceMenu["id"]}\" class=\"dropdown-toggle\" data-toggle=\"collapse\" area-expand=\"true\">{$voceMenu["nome"]}</a>";
                $querySottoMenu = "SELECT * FROM geecAd_vociMenu WHERE tipo LIKE 'voce sottomenu' AND vocePadre='{$voceMenu["id"]}' ORDER BY posizione ASC";
                $risSottoMenu = $db->eseguiQueryLettura($querySottoMenu);
                
                echo"<ul id=\"dropwdown{$voceMenu["id"]}\" class=\"list-unstyled collapse\">";
                while($sottoMenu = $risSottoMenu->fetch_assoc()) {
                    echo"<li><a href=\"{$sottoMenu["link"]}\">{$sottoMenu["nome"]}</a></li>";
                }
                echo"</ul>";
                echo"</li>";
            }
            else {
                $stringaIcona = (isset($voceMenu["icona"]) && $voceMenu["icona"] !="") ? "<i class=\"{$voceMenu["icona"]}\"></i>" :"";
                echo"<li class=\"{$personalizzazioniMenu["elementoMenu"]}\">
                        <a href=\"{$voceMenu["link"]}\" class=\"{$personalizzazioniMenu["linkMenu"]}\">$stringaIcona <span>{$voceMenu["nome"]}</span></a>
                    </li>";
            }
        }
        echo"</ul>";
    }

    /* 
    *  stampa il menu secondario nella barra superiore. Prende in input il database su cui fare la ricerca,
    *  l'id del menu e le classi css per dare un aspetto diverso al menu. 
    */ 
    function creaMenuSecondario($geecomDb, $classeCss,$idMenu) {
        $queryMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo NOT LIKE 'voce sottoMenu' ORDER BY posizione ASC";
        $risVociMenu = $geecomDb->eseguiQueryLettura($queryMenu);

        echo"<div class=\"list-group\" >";
        while($voceMenu = $risVociMenu->fetch_assoc()) {
            if($voceMenu["tipo"]=="menu a tendina") { //se si tratta di un menu a tendina va a cercare tutte le voci che deve contenere
                echo"<li class=\"dropdown\">
                <a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">{$voceMenu["nome"]} <b class=\"caret\"></b></a>";
                $querySottoMenu = "SELECT * FROM geecB_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'voce sottoMenu' AND tagSottoMenu='{$voceMenu["tagSottoMenu"]}' ORDER BY posizione ASC";
                $risSottoMenu = $geecomDb->eseguiQueryLettura($querySottoMenu);
                echo"<ul class=\"dropdown-menu\">";
                while($sottoMenu = $risSottoMenu->fetch_assoc()) { 
                    echo"<li><a href=\"{$sottoMenu["link"]}\">{$sottoMenu["nome"]}</a></li>";
                }
                echo"</ul>";
                echo"</li>";
            }
            else { 
                echo"<a href=\"{$voceMenu["link"]}\" class=\"list-group-item\" >{$voceMenu["nome"]}</a>";
            }
        }
        echo"</div>";
    }

    /*
     * funzione utilizzata nella barra superiore per trovare il contenuto tradotto
     */
    function linkContenutoTradotto($geecomDb, $impostazioni, $contenuto, $lingua) {
        $impostazioniLingue = recuperaImpostazioniLingue($geecomDb);
        if($contenuto["linguaContenuto"]=="$lingua") {
            return "#";
        }
        else {
            if($impostazioniLingue["linguaPrincipale"]!=$lingua) { // se si sta traducendo qualcosa dalla lingua principale del sito
                $query = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento = {$contenuto["id"]} AND linguaContenuto LIKE '$lingua' LIMIT 1";
            }
            else {
                $query = "SELECT * FROM geecB_contenuti WHERE id = {$contenuto["contenutoRiferimento"]} LIMIT 1";
            }
            $risTraduzione = $geecomDb->eseguiQueryLettura($query);
            if($risTraduzione->num_rows>0) {
                $paginaTradotta = $risTraduzione->fetch_assoc();
                $link = GeneratoreUrl::creaUrlArticolo($paginaTradotta, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
            else { //se non c'è rimanda all'home page della lingua scelta
                $homeEn = $geecomDb->leggiSingolaRiga("geecB_contenuti",$impostazioni["homePageEn"]);
                $link = GeneratoreUrl::creaUrlArticolo($homeEn, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);
                return"$link";
            }
        }
    }
    
    /*
     * funzione utilizzata nella barra superiore per trovare la traduzione di un elemento
     * del portfolio
     */
    function linkElementoPorfolioTradotto($geecomDb, $impostazioni, $elemento, $lingua) {
        return $impostazioni["urlSito"];
    }
    
    /*
     * funzione utilizzata nella barra superiore per trovare la traduzione di una categoria
     */
    function linkCategoriaTradotta($geecomDb, $impostazioni, $categoria, $lingua) {
        return $impostazioni["urlSito"];
    }
    
    // questa funzione stampa i collegamenti agli altri prodotti geecom presenti nello spazio web
    // se il prodotto corrispondente non è installato stampa un 'immagine grigia
    // prende in input il nome del prodotto corrente, prelevato dal file costanti.php
    // il campo prefisso contiene eventuali percorsi da aggiungere ai link e alle immagini, deve essere vuoto per le pagine principali
    // e contenere il valore ../../ per i componenti
    function stampaProdotti($geecomDb, $nomeProdotto,$prefisso) {
        $queryProdotti = "SELECT * FROM geec_prodotti";
        $risProdotti = $geecomDb->eseguiQueryLettura($queryProdotti);

        echo"<ul class=\"navbar-nav ml-auto\">";
        while($prodotto = $risProdotti->fetch_assoc()) {

            //questo controllo serve per sapere se il prodotto è quello che si sta usando, in tal caso il link sarà un #
            if($prodotto["nome"]==$nomeProdotto) {
                $linkProdotto = "#";
                $title        = "Geecom ".$prodotto["nome"]." (in uso)";
                $classeLink   = "active";
            }
            else {
                // recupero le impostazioni del prodotto
                if($prodotto["nome"]=="CMS" && $prodotto["installato"]=="si") {
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecB_impostazioni",1);
                }
                else if($prodotto["nome"]=="Admin" && $prodotto["installato"]=="si") {
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
                }
                else if($prodotto["nome"]=="Doc" && $prodotto["installato"]=="si"){
                    $impostazioni = $geecomDb->leggiSingolaRiga("geecD_impostazioni",1);
                }
                else {
                    $impostazioni = array();
                }
                
                $linkProdotto = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni, $prodotto);
                $title        = "passa a Geecom ".$prodotto["nome"];
                $classeLink   = "";
            }
            
            if($prodotto["installato"]=="si") {
                echo"<li class=\"nav-item\">
                    <a  class=\"$classeLink\" href=\"$linkProdotto\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"$title\"><img  src=\"$prefisso"."../immagini/immaginiDiSistema/icona_Geecom_{$prodotto["nome"]}.svg\" ></a>
                </li>";
            }
            else {
                echo"<li class=\"nav-item\">
                    <a class=\"disable\" href=\"#\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"Geecom {$prodotto["nome"]} non installato\"><img src=\"$prefisso"."../immagini/immaginiDiSistema/icona_Geecom_{$prodotto["nome"]}.svg\" class=\"inattivo\"></a>
                </li>";
            }
        }
        echo"</ul>";
    }

    /*
     * funzione che viene usata nella barra superiore del sito
     */
    function percorsoImmagineBandiera($lingua) {
        if($lingua=="italiano") {
            return "template/img/bandiere/italia.svg";
        }
        else if($lingua=="inglese") {
            return "template/img/bandiere/regno-unito.svg";
        }
        else if($lingua=="tedesco") {
            return "template/img/bandiere/germania.svg";
        }
        else if($lingua=="francese") {
            return "template/img/bandiere/francia.svg";
        }
        else if($lingua=="spagnolo") {
            return "template/img/bandiere/spagna.svg";
        }
        else {
            return "";
        }
    }
    
    /*
    * funzione cre restituisce le impostazioni generali della piattaforma
    * è chiamata da tutte le pagine di front end e da index.php di amministrazione
    * essendo anche la prima funzione ad essere chiamata in tutte le pagine di frontend,
    * 
    */
    function recuperaImpostazioni($geecomDb) {
        $queryControlloInstallazioneEffettuata = "SHOW tables";
        $risNumeroTabelle = $geecomDb->eseguiQueryLettura($queryControlloInstallazioneEffettuata);

        if($risNumeroTabelle->num_rows>0) {              
            return $geecomDb->leggiSingolaRiga("geecAd_impostazioni", 1);
        }
        else {
            header("Location: installazione");
            exit();
        }
    }

   /*
    * funzione cre restituisce la configurazione attiva nel momento in cui viene chiamata
    * è chiamata da tutte le pagine di front end e da varie pagine nell'area amministrativa (es creaContenuto.php)
    */
    function recuperaConfigurazioneColori($geecomDb) {
        return $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataAdmin");
    }
    
    //funzione cre restituisce le impostazioni delle lingue
    //è chiamata da tutte le pagine di front end e da index.php di amministrazione
    function recuperaImpostazioniLingue($geecomDb) {
        $queryImpostazioniLingue = "SELECT * FROM geecB_impostazioniLingue WHERE id=1";
        $risImpostazioniLingue = $geecomDb->eseguiQueryLettura($queryImpostazioniLingue);
        $impostazioniLingue = $risImpostazioniLingue->fetch_assoc();
        return $impostazioniLingue;
    }
    
    //funzione cre restituisce le impostazioni di inclusioni globali
    //è chiamata da tutte le pagine di front end e da index.php di amministrazione
    function recuperaInclusioni($geecomDb) {
        $queryInclusioni = "SELECT * FROM geecB_inclusioniGlobali WHERE id=1";
        $risInclusioni   = $geecomDb->eseguiQueryLettura($queryInclusioni);
        $inclusioni = $risInclusioni->fetch_assoc();
        return $inclusioni;
    }

    function eseguiAnalisiSeo($tipo,$titolo,$descrizione,$testo,$immagine) {
        //variabili che memorizzano l'indicatore per la seo
        $seoPositivo = "<span id=valoreSeo class=\"label label-success\">buona</span>";
        $seoDiscreto = "<span id=valoreSeo class=\"label label-warning\">discreta</span>";
        $seoNegativo = "<span id=valoreSeo class=\"label label-danger\">scadente</span>";
        
        $seoPositivoTesto = "buona";
        $seoDiscretoTesto = "discreta";
        $seoNegativoTesto = "scadente";
        $punteggioSeo = 0;

        //inizializzazione array che contiene i risultati
        $analisiSeo = array();
        $analisiSeo["esito"] = $seoNegativo;
        $analisiSeo["esitoTesto"] = $seoNegativoTesto;
        
        $suggerimenti = array();
        
        //analisi titolo
        $numeroCaratteriTitolo = strlen($titolo);
        if($numeroCaratteriTitolo > 0 && $numeroCaratteriTitolo < 20) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo corto, solo $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        else if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 50) {
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriTitolo>70) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>titolo</strong> è troppo lungo, $numeroCaratteriTitolo caratteri. Il dato ottimale è tra i 50 e i 70 caratteri.</p>";
        }
        
        //analisi descrizione
        $numeroCaratteriDescrizione = strlen($descrizione);
        if($numeroCaratteriDescrizione==0) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>descrizione</strong> è assente, inseriscila per migliorare l'indicizzazione di questo contenuto.</p>";
        }
        else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
            $punteggioSeo += 1;
        }
        else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
            $punteggioSeo += 2;
        }
        else { //descrizione troppo lunga
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>descrizione</strong> è troppo lunga, $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160 caratteri.</p>";
        }

        //analisi testo
        $numeroCaratteriTesto = strlen($testo);
        if($numeroCaratteriTesto > 0 && $numeroCaratteriTesto < 400) {
            $punteggioSeo += 0;
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriTesto caratteri. Le dimensioni minime sono di almeno 500 caratteri, quelle ottimali oltre i 1000 caratteri.</p>";
        }
        else if ($numeroCaratteriTesto > 400 && $numeroCaratteriTesto < 900) {
            $punteggioSeo += 1;
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è un po' corto, $numeroCaratteriTesto caratteri. Le dimensioni ottimali sono di almeno 1000 caratteri.</p>";
        }
        else if ($numeroCaratteriTesto > 900) {
            $punteggioSeo += 2;
        }
        else { //se non c'è testo
            $punteggioSeo += 0;
        }

        $numeroImmagini = 0;
        //analisi presenza immagini
        if ($immagine != "") {
            $numeroImmagini ++;
        }
        $numeroImmagini += substr_count($testo,"<img");
        if($numeroImmagini>0) {
            $punteggioSeo += 1;
        }
        else {
            $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> <strong>Non ci sono immagini</strong> in questo contenuto, inseriscine almeno una.</p>";
        }
        $analisiSeo["suggerimenti"] = $suggerimenti;
        
        //assegnazione valutazione
        $analisiSeo["punteggioSeo"] = $punteggioSeo;
        if($punteggioSeo > 4) {
            $analisiSeo["esito"] = $seoPositivo;
            $analisiSeo["esitoTesto"] = $seoPositivoTesto;
        }
        else if($punteggioSeo == 3 || $punteggioSeo == 4) {
            $analisiSeo["esito"] = $seoDiscreto;
            $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
        }

        return $analisiSeo;
    }
    
    function confrontoMediaPunteggio($punteggioSito,$mediaPunteggio=50) {
        if($punteggioSito>$mediaPunteggio) {
            echo"Sei <strong>sopra la media </strong>";
        }
        else if($punteggioSito==$mediaPunteggio) {
            echo"Sei <strong>nella media </strong>";
        }
        else if($punteggioSito+10>=$mediaPunteggio){
            echo"Sei <strong>di poco sotto media </strong>";
        }
        else {
            echo"Sei <strong>sotto la media </strong>";
        }
    }

    //funzione che si occupa di stampare logo (o semplice nome) e slogan del sito
    //viene usata per creare il div barraSuperiore e barraMenu
    function stampaLogo($logo,$slogan) {	
        if($logo!="") { //se il campo logo costanti sito non è vuoto viene mostrato
                echo"<a class=\"navbar-brand\" href=\"index.php\">{$logo}</a>";
        }

        if($slogan!="") { //se la costante sloganSito non è vuota viene mostrata
                echo"<div class=\"row col-xs-12 slogan\">{$slogan}</div>";
        }
    }

    /*
     * questa funzione restituisce il link di privacy di default del sito, che è
     * quello che si può impostare nella sezione legge sui cookie delle impostazioni
     */
    function linkPrivacyBase($geecomDb) {
        $leggeCookie = $geecomDb->leggiSingolaRiga("geecAd_leggeCookie",1);
        $paginaCondizioni = $geecomDb->leggiSingolaRiga("geecAd_contenuti",$leggeCookie["paginaMaggioriInformazioni"]);
        $impostazioni = $geecomDb->leggiSingolaRiga("geecAd_impostazioni",1);
        $linkPagina = GeneratoreUrl::creaUrlContenuto($paginaCondizioni, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        return $linkPagina;
    }
    
    /* stampa la versione corrente di geecom cms */
    function stampaVersioneProdotto($db) {
        $query = "SELECT * FROM geec_prodotti WHERE nome LIKE 'Admin'";
        $risQuery = $db->eseguiQueryLettura($query);
        $datiProdotto = $risQuery->fetch_assoc();
        echo($datiProdotto["versione"]);
    }

    /* funzione per creare le breadcrumb */
    function creaBreadCrumb($db,$articolo,$impostazioni ) {
        if($articolo["tipo"]!="articolo") {
            echo"
                <ol class=\"breadcrumb extraspace-top\">
                  <li><a href=\"{$impostazioni["urlSito"]}\">Home</a></li>
                  <li class=\"active\">{$articolo["titolo"]}</li>
              </ol>";	          
        }
        else {
            if($articolo["categoria"]>0) {
                $query = "SELECT * FROM geecB_categorie WHERE id={$articolo["categoria"]}";
                $risQuery = $db->eseguiQueryLettura($query);
                $categoria = $risQuery->fetch_assoc();
                $linkCategoria = GeneratoreUrl::creaUrlCategoria($categoria,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
                echo"
                    <ol class=\"breadcrumb\">
                      <li><a href=\"{$impostazioni["urlSito"]}\">Home</a></li>
                      <li><a href=\"$linkCategoria\">{$categoria["nome"]}</a></li>
                      <li class=\"active\">{$articolo["titolo"]}</li>
                  </ol>";
            }
            else {
                echo"<div class=\"col-xs-12\">
                    <ol class=\"breadcrumb\">
                      <li><a href=\"{$impostazioni["urlSito"]}\">Home</a></li>
                      <li class=\"active\">{$articolo["titolo"]}</li>
                  </ol>
                </div>";
            }
        }
    }

    /* 
     * funzione per creare voci di menu per collegare gli articoli, pagine e gallerie create 
     * utilizzata da creaContenuto.php
     */
    function creaVoceMenu($geecomDb,$contenuto, $impostazioni, $idMenu, $tipo="link", $voceSottomenu=0) {
        $link = GeneratoreUrl::creaUrlArticolo($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]);

        $queryNumeroVocimenu="SELECT * FROM geecAd_vociMenu WHERE idMenu=$idMenu ORDER BY posizione DESC LIMIT 1";		
        $result = $geecomDb->eseguiQueryLettura($queryNumeroVocimenu);
        $riga = $result->fetch_assoc();
        $posizione = $riga['posizione'] + 1;

        //viene creata una voce di menu, il campo tipo viene settato a link perché si tratta di una pagina
        $queryInserimentoVocemenu="INSERT INTO geecAd_vociMenu VALUES(NULL,$idMenu,{$contenuto["id"]},'link','{$contenuto["titolo"]}','$tipo','$voceSottomenu','$link','$posizione');";
        $geecomDb->eseguiQueryScrittura($queryInserimentoVocemenu);
    }

    // funzione usata dai componenti per creare i link degli elementi
    // usata ad esempio nel file colonneInEvidenza/creaColonneInEvidenza
    function costruisciLink($articolo) {
        $link = 'articolo.php?id='.$articolo['id'].'&alias='.$articolo['alias'];
        return $link;
    }

    // funzione per incrementare il numero di visite globale e giornaliero
    function incrementaConteggioVisite($db, $dataOggi) {
        $queryComponenti = "SELECT * FROM geecAd_visiteGiornaliere WHERE id=1";
        $risComponenti = $db->eseguiQueryLettura($queryComponenti);
        $datiVisite = $risComponenti->fetch_assoc();

        if($dataOggi != $datiVisite["dataCorrente"]) {
            $queryAggiornamentoVisite = "UPDATE geecAd_visiteGiornaliere SET numeroVisite=1, dataCorrente='$dataOggi' WHERE id=1";
        }
        else {
            $queryAggiornamentoVisite = "UPDATE geecAd_visiteGiornaliere SET numeroVisite=numeroVisite+1 WHERE id=1";
        }
        $db->eseguiQueryScrittura($queryAggiornamentoVisite);
    }

    /*
     * Questa funzione serve per aggiornare tutte le voci di menu che puntano
     * al contenuto passato in input
     */
    function aggiornaVociMenuContenuto($db,$contenuto, $ottimizzazioneSeo, $indirizzoSito) {
        $link = GeneratoreUrl::creaUrlArticolo($contenuto, $ottimizzazioneSeo, $indirizzoSito);
        $query = "SELECT * FROM geecB_vociMenu WHERE idContenuto={$contenuto["id"]}";
        $ris = $db->eseguiQueryLettura($query);
        while($voceMenu = $ris->fetch_assoc()) {
            $queryAggiornamento = "UPDATE geecB_vociMenu SET link='$link' WHERE id = {$voceMenu["id"]}";
            $db->eseguiQueryScrittura($queryAggiornamento);
        }
    }
    
    /*
     * questa funzione viene usata da creaContenuto.php e duplicaContenuto.php
     * si crea un alias  a partire dal titolo del contenuto eliminando spazi e 
     * caratteri speciali controlla se è presente nel database un articol con 
     * quell'alias
     * 
     * una funzione simile è presente anche nella classe Contenuto, in futuro quando
     * tutte le operazioni dei contenuti saranno eliminate questa funzione verrà
     * eliminata
     */
    function generaAlias($geecomDb,$titolo) {
        $alias = strtolower(ControlloreStringhe::rimuoviCaratteriSpeciali($titolo));
        $query ="SELECT * FROM geecB_contenuti WHERE titolo LIKE '$titolo'";
        $ris = $geecomDb->eseguiQueryLettura($query);
        if($ris->num_rows==0) {
            return $alias;
        }
        else {
            return $alias.$ris->num_rows;
        }
    }
    
    /*
     * Questa funzione calcola un punteggio del sito tenendo in considerazione la
     * percentuale di articoli con seo buona, discreta e scadente. Inoltre prende
     * in considerazione l'https se è attivo o meno, il titolo del sito, la 
     * descrizione del sito, da quanto tempo non vengono pubblicati contenuti e cosi via
     */
    function calcoloStatoSito($impostazioniAspetto, $geecomDb) {
        
        $articoliSeoScadente = $geecomDb->contaRigheTabella("geecB_contenuti", "punteggioSEO", "scadente");
        $articoliSeoDiscreta = $geecomDb->contaRigheTabella("geecB_contenuti", "punteggioSEO", "discreta");
        $articoliSeoBuona    = $geecomDb->contaRigheTabella("geecB_contenuti", "punteggioSEO", "buona");
            
        $totaleArticoli = $articoliSeoBuona + $articoliSeoDiscreta + $articoliSeoScadente;
        
        if($articoliSeoBuona>0) {
            $percentualeArticoliSeoBuona = $articoliSeoBuona/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoBuona = 0;
        }
        
        if($articoliSeoDiscreta>0) {        
            $percentualeArticoliSeoDiscreta = $articoliSeoDiscreta/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoDiscreta = 0;
        }
        
        if($articoliSeoScadente>0) {
            $percentualeArticoliSeoScadente = $articoliSeoScadente/$totaleArticoli * 100;
        }
        else {
            $percentualeArticoliSeoScadente = 0;
        }
        
        $punteggioSito = 100 - $percentualeArticoliSeoScadente - ($percentualeArticoliSeoDiscreta / 2);
        
        if($impostazioniAspetto["attivaHttps"]!="si") {
            $punteggioSito = $punteggioSito -2;
        }
        
        if(strlen($impostazioniAspetto["titoloSito"])<25) {
            $punteggioSito = $punteggioSito -2;
        }
        
        if(strlen($impostazioniAspetto["descrizioneSito"])==0) {
            $punteggioSito = $punteggioSito -2;
        }
        else if(strlen($impostazioniAspetto["descrizioneSito"])<50) {
            $punteggioSito = $punteggioSito -1;
        }
        
        if($punteggioSito < 0) {
            $punteggioSito = 0;
        }
        
        $parametriRicerca["tipo"] = "pagina";
        $parametriRicerca["punteggioSeo"] = "scadente";
        $ricerca = new Ricerca($geecomDb, "geecB_contenuti", 10, $parametriRicerca, "", "");
        $ricerca->eseguiQueryConteggio();
        $numeroPagineSeoScadente = $ricerca->getNumeroOggettiTrovati();
        
        // cambio il parametro punteggioSeo per trovare le pagine con seo discreta
        $parametriRicerca["punteggioSeo"] = "discreta";
        $ricerca->setParametriRicerca($parametriRicerca);
        $ricerca->eseguiQueryConteggio();        
        $numeroPagineSeoDiscreta = $ricerca->getNumeroOggettiTrovati();
        
        // cambio il parametro punteggioSeo per trovare le pagine con seo discreta
        $parametriRicerca["punteggioSeo"] = "buona";
        $ricerca->setParametriRicerca($parametriRicerca);
        $ricerca->eseguiQueryConteggio();        
        $numeroPagineSeoBuona = $ricerca->getNumeroOggettiTrovati();

        // eseguo ora il conteggio degli articoli
        $parametriRicerca["tipo"] = "articolo";
        $parametriRicerca["punteggioSeo"] = "scadente";
        $ricerca->setParametriRicerca($parametriRicerca);
        $ricerca->eseguiQueryConteggio();
        $numeroArticoliSeoScadente = $ricerca->getNumeroOggettiTrovati();
        
        // cambio il parametro punteggioSeo per trovare le pagine con seo discreta
        $parametriRicerca["punteggioSeo"] = "discreta";
        $ricerca->setParametriRicerca($parametriRicerca);
        $ricerca->eseguiQueryConteggio();        
        $numeroArticoliSeoDiscreta = $ricerca->getNumeroOggettiTrovati();
        
        // cambio il parametro punteggioSeo per trovare le pagine con seo discreta
        $parametriRicerca["punteggioSeo"] = "buona";
        $ricerca->setParametriRicerca($parametriRicerca);
        $ricerca->eseguiQueryConteggio();        
        $numeroArticoliSeoBuona = $ricerca->getNumeroOggettiTrovati();
        
        // calcolo delle interazioni
        $numeroCommenti    = $geecomDb->contaRigheTabella("geecB_commenti");
        $numeroCommentiUltimaSettimana =  $geecomDb->contaRigheTabella("geecB_commenti");
        $numeroEmailInviate = $geecomDb->sommaValoriColonna("contatoreInvii","geec_form");
        $numeroClickInvitoAzione = $geecomDb->sommaValoriColonna("numeroClick","geec_invitiAzione");
        $numeroClickSlider = $geecomDb->sommaValoriColonna("numeroClick","geec_slide");
        $numeroClickBanner = $geecomDb->sommaValoriColonna("numeroClickTotali","geec_banner");
        $numeroClickTabellePrezzi = $geecomDb->sommaValoriColonna("numeroClick","geec_colonneTabellaPrezzi");
        
        // calcolo dei giorni dall'ultimo contenuto pubblicato
        $queryUltimoArticolo = "SELECT * FROM geecB_contenuti ORDER BY id DESC LIMIT 1";
        $risQueryUltimoArticolo  = $geecomDb->eseguiQueryLettura($queryUltimoArticolo);
        $ultimoArticolo =  $risQueryUltimoArticolo->fetch_assoc();
        $intervallo = date_diff(date_create(date("Y-m-d")), date_create($ultimoArticolo["dataCreazione"]));
        
        // prepara l'array per restituire le informazioni
        $risultatoAnalisi = array();
        $risultatoAnalisi["percentualeArticoliSeoScadente"] = $percentualeArticoliSeoScadente;
        $risultatoAnalisi["percentualeArticoliSeoDiscreta"] = $percentualeArticoliSeoDiscreta; 
        $risultatoAnalisi["percentualeArticoliSeoBuona"]    = $percentualeArticoliSeoBuona; 
        $risultatoAnalisi["punteggioSito"] = $punteggioSito;
        $risultatoAnalisi["numeroPagineSeoScadente"] = $numeroPagineSeoScadente;
        $risultatoAnalisi["numeroPagineSeoDiscreta"] = $numeroPagineSeoDiscreta;
        $risultatoAnalisi["numeroPagineSeoBuona"] = $numeroPagineSeoBuona;
        $risultatoAnalisi["numeroArticoliSeoScadente"] = $numeroArticoliSeoScadente;
        $risultatoAnalisi["numeroArticoliSeoDiscreta"] = $numeroArticoliSeoDiscreta;
        $risultatoAnalisi["numeroArticoliSeoBuona"] = $numeroArticoliSeoBuona;
        $risultatoAnalisi["interazioniTotali"]      = $numeroCommenti + $numeroEmailInviate + $numeroClickInvitoAzione;
        $risultatoAnalisi["numeroCommenti"] = $numeroCommenti;
        $risultatoAnalisi["numeroClickSlider"] = $numeroClickSlider;
        $risultatoAnalisi["numeroClickBanner"] = $numeroClickBanner;
        $risultatoAnalisi["numeroClickTabellePrezzi"] = $numeroClickTabellePrezzi;
        $risultatoAnalisi["interazioniUltimaSettimana"] = $numeroCommentiUltimaSettimana;
        $risultatoAnalisi["numeroEmailInviate"] = $numeroEmailInviate;
        $risultatoAnalisi["numeroClickInvitoAzione"] = $numeroClickInvitoAzione;
        $giorniDallultimaPubblicazione = ($intervallo->format("%m") * 30) +$intervallo->format("%d");
        $risultatoAnalisi["giorniDallultimaPubblicazione"] = $giorniDallultimaPubblicazione;
        
        if($punteggioSito>=75) {
            $risultatoAnalisi["classeTestiCss"] = "success";
            $risultatoAnalisi["icona"] = "fa fa-smile-o";
        }
        else if($punteggioSito<75 && $punteggioSito>35){
            $risultatoAnalisi["classeTestiCss"] = "warning";
            $risultatoAnalisi["icona"] = "fa fa-meh-o";
        }
        else {
            $risultatoAnalisi["classeTestiCss"] = "danger";
            $risultatoAnalisi["icona"] = "fa fa-frown-o";
        }
        return $risultatoAnalisi;
    }
    
    /*
     * Funzione per il calcolo dell'utilizzo degli utenti, viene usata nella dashboard amministrativa
     */
    function calcoloUtilizzoPiattaforma($numeroUtenti,$utentiAttivi) {
        $datiUtilizzo = array();
        if($utentiAttivi==0) { //se il numero di utenti attivi è 0 viene messo a 1 per evitare errori di tipo division by zero
            $utentiAttivi = 1;
        }
        if($numeroUtenti==0) {
            $datiUtilizzo["classeBoxUtilizzo"]   = "info";
            $datiUtilizzo["percentualeUtilizzo"] = 0;
            $datiUtilizzo["fraseUtilizzo"] = "Sei <strong>sotto la media </strong>";
        }
        else {
            $percentualeUtilizzo = ceil(($numeroUtenti * 100) / $utentiAttivi);
            $datiUtilizzo["percentualeUtilizzo"] = $percentualeUtilizzo;
            if($percentualeUtilizzo>70) {
                $datiUtilizzo["classeBoxUtilizzo"]   = "success";
                $datiUtilizzo["fraseUtilizzo"] = "Sei <strong>sopra la media </strong>";
            }
            else if($percentualeUtilizzo>40 && $percentualeUtilizzo<70) {
                $datiUtilizzo["classeBoxUtilizzo"]   = "warning";
                $datiUtilizzo["fraseUtilizzo"] = "Sei <strong>sopra la media </strong>";
            }
            else {
                $datiUtilizzo["classeBoxUtilizzo"]   = "danger";
                $datiUtilizzo["fraseUtilizzo"] = "Sei <strong>sotto la media </strong>";
            }
        }
        return $datiUtilizzo;
    }
    
    /*
     * questa funzione viene utilizzata per stampare un testo
     * motivazionale per l'utente
     */
    function stampaTestoMotivazionale($numero) {
        if($numero<10) {
            echo "<strong class=\"text-danger\"><br>Dobbiamo migliorare!</strong>";
        }
        else if($numero<10 && $numero<100) {
            echo "<strong class=\"text-warning\"><br>Possiamo fare di meglio!</strong>";
        }
        else if($numero<100) {
            echo "<strong class=\"text-success\"><br>Ottimo!</strong>";
        }
    }
    
    /*
     * questa funzione viene utilizzata per stampare un testo
     * motivazionale per l'utente
     */
    function stampaIconaMotivazionale($numero) {
        if(!is_numeric($numero)) {
            echo "fa fa-meh-o fa-2x text-muted";
        }
        else if($numero<10) {
            echo "fa fa-frown-o fa-2x text-danger";
        }
        else if($numero<10 && $numero<100) {
            echo "fa fa-meh-o fa-2x text-warning";
        }
        else if($numero<100) {
            echo "fa fa-smile-o fa-2x text-success";
        }
    }
    
    /*
     * Crea il link che rimanda lla pagina che modifica il componente specificomodificare un componente 
     */
    function creaLinkModifica($componente) {
        if($componente["nome"]=="Risorse") {
            return "componenti/visualizzatoreRisorse/creaVisualizzatoreRisorse.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Visualizzatore galleria") {
            return "creaContenuto.php?id={$componente["idElemento"]}";
        }
        else if($componente["nome"]=="Visualizzatore riga prodotti") {
            return "componenti/ecommerce/creaRigaVisualizzazioneProdotti.php?id={$componente["idElemento"]}";
        }
        else {
            $nomeSenzaSpazi = str_replace(" ", "",ucwords($componente["nome"]));
            $primoCarattere = substr($nomeSenzaSpazi, 0,1);
            $primoCarattereMinuscolo = strtolower($primoCarattere);
            $arrayParole = explode(" ", $componente["nome"]);
            $cartellaComponente = $primoCarattereMinuscolo.substr($nomeSenzaSpazi, 1, strlen($nomeSenzaSpazi)-1);
            return "componenti/$cartellaComponente/crea{$arrayParole[0]}.php?id={$componente["idElemento"]}";
        }
    }
    
    /*
     * Funzione utilizzata per eliminare tutte le occorrenze di un componente. È presente nei metodi elimina
     * di tutte le classi che gestiscono i componenti. Va ad eliminare ogni occorrenza della tabella geecB_composizionePagine
     * dove è presente il componente di quel tipo con quell'occorrenza
     * 
     * $geecomDb     -> il database su cui effettuare le operazioni
     * $idOccorrenza -> l'id dell'occorrenza del componente che si vuole eliminare
     * $idComponente -> l'id del componente nella tabella geecB_componenti
     */
    function eliminaOccorrenzeComponente($geecomDb,$idOccorrenza,$idComponente) {
        $queryEliminaCercaOccorrenzeComposizionePagine = "SELECT * FROM geecAd_composizionePagine WHERE idElemento = $idOccorrenza AND idComponente = $idComponente";
        $risOccorrenze = $geecomDb->eseguiQueryLettura($queryEliminaCercaOccorrenzeComposizionePagine);
        while($occorrenza = $risOccorrenze->fetch_assoc()) {
            $geecomDb->eseguiQueryCancellazione("geecAd_composizionePagine",$occorrenza["id"]);
        }
    }
    
    // invia l'email al gruppo di utenti selezionato
    // $risUtenti contiene gli utenti a cui inviare il messaggio, è il prodotto di una query
    function inviaEmail($messaggio,$impostazioni,$risUtenti,$oggetto,$testo) {
        $mailInviate    = 0;
        $mailNonInviate = 0;
        $logInvio       = "";
        $messaggio->IsSMTP();

        $messaggio->Host = $impostazioni["hostSmtp"];
        $messaggio->Port = $impostazioni["portaSmtp"];
        $messaggio->SMTPAuth = true; 
        // $messaggio->SMTPSecure = "ssl"; parametrizzare questo campo in modo da consentire di scegliere se usare ssl o meno
        $messaggio->Username = $impostazioni["utenteSmtp"];
        $messaggio->Password = $impostazioni["passwordSmtp"];
        $messaggio->setFrom($impostazioni["emailMittente"],$impostazioni["nomeMittente"]);

        $messaggio->IsHTML(true);

        $messaggio->AddReplyTo($impostazioni["emailMittente"]);
        $messaggio->Subject="$oggetto";
        $messaggio->MsgHTML($testo);

        //invia la mail agli utenti del gruppo selezionato
        while($utente=$risUtenti->fetch_assoc()) {
            // invio l'email al singolo utente
            $messaggio->addAddress($utente['email'], $utente['nome']);
            if (!$messaggio->send()) {
                $logInvio .= "invio a {$utente["email"]} non riuscito: ".$messaggio->ErrorInfo;
                $mailNonInviate++;
            }
            else {
                $mailInviate++;
            }

            $messaggio->clearAddresses();
            $messaggio->clearAttachments();
        }
        
        $reportInvio = array("mailInviate"=>$mailInviate,"mailNonInviate"=>$mailNonInviate,"logInvio"=>$logInvio);
        return $reportInvio;
    }

    // invia le notifiche al gruppo di utenti selezionato
    // $risUtenti contiene gli utenti a cui inviare il messaggio, è il prodotto di una query
    function inviaNotifiche($db,$risUtenti,$oggetto) {
        while($utente=$risUtenti->fetch_assoc()) {
            $dataInvio  = date("Y-m-d H:i");
            $query = "INSERT geec_notifiche VALUES(NULL,'Admin','notificaUtente',{$utente["id"]},'Nuova comunicazione con oggetto $oggetto','comunicazioni.php?tipo=comunicazione','no','$dataInvio')";
            $db->eseguiQueryScrittura($query);
        }
    }
    
    /*
     * questa funzione viene usata nei rami if che richiedono un controllo
     * se si è amministratori, altrimenti chiunque potrebbe aggiorare le tabelle
     */
    function controlloAccessoAdmin($prefisso = "../") {
        if(!isset($_SESSION["geecomAdmin_email"])) {
            header("Location: ".$prefisso."../index.php");
            exit();
        }
    }
    
    /*
     * questa funzione viene usata nei rami if che richiedono un controllo
     * se si è amministratori, altrimenti chiunque potrebbe aggiorare le tabelle
     */
    function controlloAccessoUtente($prefisso = "../") {
        if(!isset($_SESSION["geecomUser_email"])) {
            header("Location: ".$prefisso."../index.php");
            exit();
        }
    }
